# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdmdlvalue import SDMDLValue
from ..sdapiobject import SDAPIObject
from ..sdapiobject import SDApiError
from ..apiexception import APIException

class SDMDLValueCall(SDMDLValue):
    """
    Class used to store information about a MDL call value
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDMDLValueCall
        """
        super(SDMDLValueCall, self).__init__(APIContext, handle, *args, **kwargs)

    def getValue(self) -> str:
        """
        Get the value as a string reference those content is implementation defined

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDMDLValueCall_getValue(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def setValue(self, value : str) -> None:
        """
        Reset the value of the reference

        :param value: The new item reference value
        """
        _res = self.mAPIContext.SDMDLValueCall_setValue(self.mHandle, ctypes.create_string_buffer(value.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

